function test_suite = testDiff %#ok<STOUT>
initTestSuite;

function testEmpty %#ok<*DEFNU>
x = polysym.empty;
assertTrue(isempty(diff(x)))

function testDefault
x = polysym;
assertTrue(isempty(diff(x)))

function testScalar
x = polysym(pi);
assertTrue(isempty(diff(x)))

function testRowVector
polysyms x y z
assertEqual(diff([x y z]),[y-x z-y])

function testColumnVector
polysyms x y z
assertEqual(diff([x; y; z]),[y-x; z-y])

function testHigherDiff
polysyms x y z
assertEqual(diff([x; y; z],2),(z-y)-(y-x))

function testEvenHigherDiff
polysyms x y z
assertTrue(isempty(diff([x; y; z],3)))

function testInvalidDifferenceOrder
x = polysym('x',[1 3]);
f = @() diff(x,-1,2);
assertExceptionThrown(f,'MATLAB:polysym:diff:expectedPositive')

function testInvalidDimension
polysyms x
f = @() diff(x,1,3);
assertExceptionThrown(f,'MATLAB:polysym:diff:notLess')
